// // // // // // // // // // // // // // // //
//
//	DigiMeter.cc
//
//	erstellt 23.4.98 von Andreas Warnke
//	geändert 23.4.98 von Andreas Warnke
//





// // // // // // // // // // // // // // // //
//
//	include
//

#include <View.h>
#include "DigiMeter.h"



// // // // // // // // // // // // // // // //
//	
//	Konstruktor:
//	

DigiMeter :: DigiMeter (
	BRect inFrame,
	const char * inName,
	int inGreen,
	int inYellow,
	int inRed,
	uint32 inFlags )
	: BView ( inFrame, inName, 0, inFlags )
{
	//	Copy Values:
	Green = inGreen;
	Yellow = inYellow;
	Red = inRed;
	CurrentValue = 0;
};



// // // // // // // // // // // // // // // //
//	
//	Destruktor:
//	

DigiMeter :: ~DigiMeter ()
{
	//	Nothing to do.
};



// // // // // // // // // // // // // // // //
//	
//	SetValue:
//	

void DigiMeter :: SetValue ( int inValue )
{
	//	Parametercheck:
	if ( inValue < 0 )
		inValue = 0;
	if ( inValue > Red + Green + Yellow )
		inValue = Red + Green + Yellow;
		
	if ( inValue != CurrentValue )
	{
		//	Value Changed.
		CurrentValue = inValue;
		Draw ( Bounds () );
	}
};



// // // // // // // // // // // // // // // //
//	
//	Draw
//	

void DigiMeter :: Draw ( BRect inBounds )
{
	//	Berechnen benötigter Werte:
	int sMax = Red + Green + Yellow;
	float sWidth = Bounds () . Width ();
	float sHeight = Bounds () . Height ();
	int sDiodeWidth = ( sWidth - ( sMax + 1 ) * eBorder ) / sMax;
	int sLeftBorder = ( sWidth - ( sMax * sDiodeWidth ) - ( ( sMax - 1 ) * eBorder ) ) / 2;

	//	Male alle Dioden:
	for ( int sPos = 0; sPos < sMax; sPos ++ )
	{
		//	Male die Diode:
		//	Wähle Farbe:
		if ( sPos < CurrentValue )
			//	An:
			if ( sPos < Green )
				//	Grün:
				SetHighColor ( 0x00, 0xee, 0x00, 0x00 );
			else if ( sPos < Green + Yellow )
				//	Gelb:
				SetHighColor ( 0xff, 0xee, 0x00, 0x00 );
			else
				//	Rot:
				SetHighColor ( 0xff, 0x00, 0x00, 0x00 );
		else
			//	Aus:
			if ( sPos < Green )
				//	Grün:
				SetHighColor ( 0x00, 0x99, 0x00, 0x00 );
			else if ( sPos < Green + Yellow )
				//	Gelb:
				SetHighColor ( 0xaa, 0x99, 0x00, 0x00 );
			else
				//	Rot:
				SetHighColor ( 0xaa, 0x00, 0x00, 0x00 );
		//	Berechne Position:
		float sLeft = sLeftBorder + ( eBorder + sDiodeWidth ) * sPos;
		float sRight = sLeft + sDiodeWidth - 1;
		if ( sLeft <= sRight )
			FillRect ( BRect ( sLeft, eBorder, sRight, sHeight - eBorder ) );
	};
};



//
//	The End
//
// // // // // // // // // // // // // // // //
